clear();
clc();
close all;                              %Plots schlieen

%KONFIGURATION---------------------------------------------------------------------
aLGS(1,:)=[ 2,-1, 4, 1,-1,"X1","=",  7];
aLGS(2,:)=[-1, 3,-2,-1, 2,"X2","=",  1];
aLGS(3,:)=[ 5, 1, 3,-4, 1,"X3","=", 33];
aLGS(4,:)=[ 3,-2,-2,-2, 3,"X4","=", 24];
aLGS(5,:)=[-4,-1,-5, 3,-4,"X5","=",-49];

%PRUEFUNG--------------------------------------------------------------------------
iANZAHL_GLEICHUNGEN = size(aLGS,1);                                                 %Gibt die Anzahl an Zeilen zurck (Parameter 1)
iANZAHL_WERTE = size(aLGS,2)-3;                                                     %Gibt die Anzahl der Spalten zurck (Parameter 2) abzglich 3 ("X";"=";Ergebnis)
if(iANZAHL_GLEICHUNGEN<iANZAHL_WERTE)
   fprintf("Scotty, wir haben ein Problem!\n"); 
   fprintf("Es gibt weniger Gleichungen als Unbekannte!\n"); 
   return;                                                                          %Hoffe das beendet das Skript vorzeitig
end
fprintf("Lineares Gleichungssystem b=A*x \n");
disp(aLGS);

%LR_ZERLEGUNG----------------------------------------------------------------------
for(i=1:1:iANZAHL_GLEICHUNGEN)
    aR(i,:)=str2double(aLGS(i,1:iANZAHL_WERTE));                                    %Initialisierung: bertragen der Werte des Gleichungssystems aLGS
end
aL=eye(iANZAHL_WERTE,iANZAHL_GLEICHUNGEN);                                          %Initialisierung: 0-Matrix mit 1 auf der Diagonale
for(i=1:1:iANZAHL_GLEICHUNGEN-1)    
    %VERBLEIBENDE_GLEICHUNGEN_ABARBEITEN-------------------------------------------
    for(j=i+1:1:iANZAHL_GLEICHUNGEN)                                                %Startet immer bei i+1, weil die nchste berechnet wird
        Quotient=aR(j,i)/aR(i,i);
        aL(j,i)=Quotient;                                                           %Beschreibung der Quotienten auf die L-Matrix       
        %ELEMENTE_DER_GLEICHUNGEN_ABARBEITEN---------------------------------------
        for(k=i:1:iANZAHL_WERTE)                                                    %Startet immer bei i, weil sukzessive von links die Werte 0 werden (ist also nur Optimierung: knnte auch einfach bei 1 starten)
            aR(j,k)=aR(j,k)-(Quotient*aR(i,k));
        end
    end
end
fprintf("R-Matrix = \n");
disp(aR);
fprintf("L-Matrix = \n");
disp(aL);

%INITIALISIERUNG_DER_MATRIX_L*y=b--------------------------------------------------
for(i=1:1:iANZAHL_GLEICHUNGEN)
    aLYB(i,j)="String-Initialisierung";
    for(j=1:1:iANZAHL_WERTE)
        aLYB(i,j)=aL(i,j);
    end
    aLYB(i,j+1)=strcat("Y",num2str(i));
    aLYB(i,j+2)="=";
    aLYB(i,j+3)=str2double(aLGS(i,size(aLGS,2)));
end
fprintf("L*y=b Gleichungssystem = \n");
disp(aLYB);

%VORWRTSAUFLSUNG-----------------------------------------------------------------
for(i=1:1:iANZAHL_GLEICHUNGEN)
    Zwischenspeicher=0;
    for(j=1:1:i-1)
        Zwischenspeicher=Zwischenspeicher+(aL(i,j)*str2double(aY(j,size(aY,2))));
    end
    aY(i,1)=strcat("Y",num2str(i));
    aY(i,2)="=";
    aY(i,3)=(str2double(aLGS(i,size(aLYB,2)))-Zwischenspeicher)/aL(i,i);
end
fprintf("Y-Lsungsvektor = \n");
disp(aY);

%INITIALISIERUNG_DER_MATRIX_R*x=Y--------------------------------------------------
for(i=1:1:iANZAHL_GLEICHUNGEN)
    aRXY(i,j)="String-Initialisierung";
    for(j=1:1:iANZAHL_WERTE)
        aRXY(i,j)=aR(i,j);
    end
    aRXY(i,j+1)=strcat("X",num2str(i));
    aRXY(i,j+2)="=";
    aRXY(i,j+3)=aY(i,3);
end
fprintf("R*x=Y Gleichungssystem = \n");
disp(aRXY);

%RCKWRTSAUFLSUNG----------------------------------------------------------------
for(i=iANZAHL_GLEICHUNGEN:-1:1)
    Zwischenspeicher=0;
    for(j=i+1:1:iANZAHL_WERTE)
        Zwischenspeicher=Zwischenspeicher+(str2double(aRXY(i,j))*str2double(aX(j,size(aX,2))));
    end
    aX(i,1)=strcat("X",num2str(i));
    aX(i,2)="=";
    aX(i,3)=(str2double(aRXY(i,size(aRXY,2)))-Zwischenspeicher)/str2double(aRXY(i,i));
end
fprintf("X-Lsungsvektor = \n");
disp(aX);

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aLGS aL aR aLYB aY aRXY aX                                         %Workspace aufrumen